
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{
	[TestFixture]
	public class DAL_PatientTransfusionComment : BaseTest 
	{		
		
		private DataTable _dtPatientTransfusionComment;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtPatientTransfusionComment = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM PatientTransfusionComment WHERE PatientTransfusionGuid IS NOT NULL AND RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", false);
				if (this._dtPatientTransfusionComment.Rows.Count == 0)
				{
					new BOL.UnitTests.BOL_PatientTransfusionReaction().SaveSpecimenChecks_Pass();
					this._dtPatientTransfusionComment = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM PatientTransfusionComment WHERE PatientTransfusionGuid IS NOT NULL AND RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);
				}
				this.RefreshData = false;
			}
		}


		[Test]
		public void GetEmptyPatientTransfusionCommentTable_Pass()
		{
			DataTable dtTest = DAL.PatientTransfusionComment.GetEmptyPatientTransfusionCommentTable();

			Assert.AreEqual(TABLES.PatientTransfusionComment.TableName, dtTest.TableName, "TableName");
			Assert.AreEqual(12, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionComment.CannedCommentGuid), TABLES.PatientTransfusionComment.CannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionComment.CommentCategoryCode), TABLES.PatientTransfusionComment.CommentCategoryCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionComment.DivisionCode), TABLES.PatientTransfusionComment.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionComment.LastUpdateDate), TABLES.PatientTransfusionComment.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionComment.LastUpdateUser), TABLES.PatientTransfusionComment.LastUpdateUser);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionComment.PatientTransfusionCommentGuid), TABLES.PatientTransfusionComment.PatientTransfusionCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionComment.PatientTransfusionCommentText), TABLES.PatientTransfusionComment.PatientTransfusionCommentText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionComment.PatientTransfusionGuid), TABLES.PatientTransfusionComment.PatientTransfusionGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionComment.PatientTransfusionReactionGuid), TABLES.PatientTransfusionComment.PatientTransfusionReactionGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionComment.PreTransfusionIndicator), TABLES.PatientTransfusionComment.PreTransfusionIndicator);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionComment.RecordStatusCode), TABLES.PatientTransfusionComment.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionComment.RowVersion), TABLES.PatientTransfusionComment.RowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetEmptyPatientTransfusionCommentTable_Fail()
		{
		}

		[Test]
		public void GetComments_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtPatientTransfusionComment.Rows[0][TABLES.PatientTransfusionComment.PatientTransfusionGuid];

			DataTable dtTest = DAL.PatientTransfusionComment.GetComments(unitGuid, System.Guid.Empty, UnitTestConfig.TestDivisionCode);

			Assert.AreEqual(12, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true,dtTest.Columns.Contains(TABLES.PatientTransfusionComment.PatientTransfusionCommentGuid), TABLES.PatientTransfusionComment.PatientTransfusionCommentGuid);
			Assert.AreEqual(true,dtTest.Columns.Contains(TABLES.PatientTransfusionComment.PatientTransfusionGuid), TABLES.PatientTransfusionComment.PatientTransfusionGuid);
			Assert.AreEqual(true,dtTest.Columns.Contains(TABLES.PatientTransfusionComment.PatientTransfusionReactionGuid), TABLES.PatientTransfusionComment.PatientTransfusionReactionGuid);
			Assert.AreEqual(true,dtTest.Columns.Contains(TABLES.PatientTransfusionComment.CannedCommentGuid), TABLES.PatientTransfusionComment.CannedCommentGuid);
			Assert.AreEqual(true,dtTest.Columns.Contains(TABLES.PatientTransfusionComment.CommentCategoryCode), TABLES.PatientTransfusionComment.CommentCategoryCode);
			
			Assert.AreEqual(true,dtTest.Columns.Contains(TABLES.PatientTransfusionComment.PatientTransfusionCommentText), TABLES.PatientTransfusionComment.PatientTransfusionCommentText);
			Assert.AreEqual(true,dtTest.Columns.Contains(TABLES.PatientTransfusionComment.PreTransfusionIndicator), TABLES.PatientTransfusionComment.PreTransfusionIndicator);
			Assert.AreEqual(true,dtTest.Columns.Contains(TABLES.PatientTransfusionComment.DivisionCode), TABLES.PatientTransfusionComment.DivisionCode);
			Assert.AreEqual(true,dtTest.Columns.Contains(TABLES.PatientTransfusionComment.RecordStatusCode), TABLES.PatientTransfusionComment.RecordStatusCode);			
			Assert.AreEqual(true,dtTest.Columns.Contains(TABLES.PatientTransfusionComment.LastUpdateUser), TABLES.PatientTransfusionComment.LastUpdateUser);

			Assert.AreEqual(true,dtTest.Columns.Contains(TABLES.PatientTransfusionComment.LastUpdateFunctionId), TABLES.PatientTransfusionComment.LastUpdateFunctionId);
			Assert.AreEqual(true,dtTest.Columns.Contains(TABLES.PatientTransfusionComment.RowVersion), TABLES.PatientTransfusionComment.RowVersion);
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetComments_EmptyGuids_Fail()
		{
			//TODO: Check for null patientTransfusionGuid and assigning DBNull will never be reached cuz of the first
			//      check that raises an argument exception - remove : Unreachable code
			DataTable dtTest = DAL.PatientTransfusionComment.GetComments(System.Guid.Empty, System.Guid.Empty, UnitTestConfig.TestDivisionCode);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetComments_EmptyDivision_Fail()
		{
			DataTable dtTest = DAL.PatientTransfusionComment.GetComments(System.Guid.NewGuid(), System.Guid.NewGuid(), string.Empty);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");

		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetComments_NullDivision_Fail()
		{
			DataTable dtTest = DAL.PatientTransfusionComment.GetComments(System.Guid.NewGuid(), System.Guid.NewGuid(), null);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}



	}
}
#endif
